/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.io.nativeio;

import java.io.IOException;

/**
 * An exception generated by a call to the native IO code.
 *
 * These exceptions simply wrap <i>errno</i> result codes.
 */
public class NativeIOException extends IOException {
  private static final long serialVersionUID = -6615764817732323232L;
  private Errno errno;

  public NativeIOException(String msg, Errno errno) {
    super(msg);
    this.errno = errno;
  }

  public Errno getErrno() {
    return errno;
  }

  public String toString() {
    return errno.toString() + ": " + super.getMessage();
  }
}


