SELECT '<HIVE-6458 Add schema upgrade scripts for metastore changes related to permanent functions>' AS ' ';

CREATE TABLE IF NOT EXISTS `FUNCS` (
  `FUNC_ID` BIGINT(20) NOT NULL,
  `CLASS_NAME` VARCHAR(4000) CHARACTER SET latin1 COLLATE latin1_bin,
  `CREATE_TIME` INT(11) NOT NULL,
  `DB_ID` BIGINT(20),
  `FUNC_NAME` VARCHAR(128) CHARACTER SET latin1 COLLATE latin1_bin,
  `FUNC_TYPE` INT(11) NOT NULL,
  `OWNER_NAME` VARCHAR(128) CHARACTER SET latin1 COLLATE latin1_bin,
  `OWNER_TYPE` VARCHAR(10) CHARACTER SET latin1 COLLATE latin1_bin,
  PRIMARY KEY (`FUNC_ID`),
  UNIQUE KEY `UNIQUEFUNCTION` (`FUNC_NAME`, `DB_ID`),
  KEY `FUNCS_N49` (`DB_ID`),
  CONSTRAINT `FUNCS_FK1` FOREIGN KEY (`DB_ID`) REFERENCES `DBS` (`DB_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `FUNC_RU` (
  `FUNC_ID` BIGINT(20) NOT NULL,
  `RESOURCE_TYPE` INT(11) NOT NULL,
  `RESOURCE_URI` VARCHAR(4000) CHARACTER SET latin1 COLLATE latin1_bin,
  `INTEGER_IDX` INT(11) NOT NULL,
  PRIMARY KEY (`FUNC_ID`, `INTEGER_IDX`),
  CONSTRAINT `FUNC_RU_FK1` FOREIGN KEY (`FUNC_ID`) REFERENCES `FUNCS` (`FUNC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

