#
# Autogenerated by Thrift
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#

require 'thrift/protocol'
require 'thrift'
require 'hadoopfs_types'

module ThriftHadoopFileSystem
  class Client
    include Thrift::Client

    def setInactivityTimeoutPeriod(periodInSeconds)
      send_setInactivityTimeoutPeriod(periodInSeconds)
      recv_setInactivityTimeoutPeriod()
    end

    def send_setInactivityTimeoutPeriod(periodInSeconds)
      send_message('setInactivityTimeoutPeriod', SetInactivityTimeoutPeriod_args, :periodInSeconds => periodInSeconds)
    end

    def recv_setInactivityTimeoutPeriod()
      result = receive_message(SetInactivityTimeoutPeriod_result)
      return
    end

    def shutdown(status)
      send_shutdown(status)
      recv_shutdown()
    end

    def send_shutdown(status)
      send_message('shutdown', Shutdown_args, :status => status)
    end

    def recv_shutdown()
      result = receive_message(Shutdown_result)
      return
    end

    def create(path)
      send_create(path)
      return recv_create()
    end

    def send_create(path)
      send_message('create', Create_args, :path => path)
    end

    def recv_create()
      result = receive_message(Create_result)
      return result.success unless result.success.nil?
      raise result.ouch unless result.ouch.nil?
      raise Thrift::ApplicationException.new(Thrift::ApplicationException::MISSING_RESULT, 'create failed: unknown result')
    end

    def createFile(path, mode, overwrite, bufferSize, block_replication, blocksize)
      send_createFile(path, mode, overwrite, bufferSize, block_replication, blocksize)
      return recv_createFile()
    end

    def send_createFile(path, mode, overwrite, bufferSize, block_replication, blocksize)
      send_message('createFile', CreateFile_args, :path => path, :mode => mode, :overwrite => overwrite, :bufferSize => bufferSize, :block_replication => block_replication, :blocksize => blocksize)
    end

    def recv_createFile()
      result = receive_message(CreateFile_result)
      return result.success unless result.success.nil?
      raise result.ouch unless result.ouch.nil?
      raise Thrift::ApplicationException.new(Thrift::ApplicationException::MISSING_RESULT, 'createFile failed: unknown result')
    end

    def open(path)
      send_open(path)
      return recv_open()
    end

    def send_open(path)
      send_message('open', Open_args, :path => path)
    end

    def recv_open()
      result = receive_message(Open_result)
      return result.success unless result.success.nil?
      raise result.ouch unless result.ouch.nil?
      raise Thrift::ApplicationException.new(Thrift::ApplicationException::MISSING_RESULT, 'open failed: unknown result')
    end

    def append(path)
      send_append(path)
      return recv_append()
    end

    def send_append(path)
      send_message('append', Append_args, :path => path)
    end

    def recv_append()
      result = receive_message(Append_result)
      return result.success unless result.success.nil?
      raise result.ouch unless result.ouch.nil?
      raise Thrift::ApplicationException.new(Thrift::ApplicationException::MISSING_RESULT, 'append failed: unknown result')
    end

    def write(handle, data)
      send_write(handle, data)
      return recv_write()
    end

    def send_write(handle, data)
      send_message('write', Write_args, :handle => handle, :data => data)
    end

    def recv_write()
      result = receive_message(Write_result)
      return result.success unless result.success.nil?
      raise result.ouch unless result.ouch.nil?
      raise Thrift::ApplicationException.new(Thrift::ApplicationException::MISSING_RESULT, 'write failed: unknown result')
    end

    def read(handle, offset, size)
      send_read(handle, offset, size)
      return recv_read()
    end

    def send_read(handle, offset, size)
      send_message('read', Read_args, :handle => handle, :offset => offset, :size => size)
    end

    def recv_read()
      result = receive_message(Read_result)
      return result.success unless result.success.nil?
      raise result.ouch unless result.ouch.nil?
      raise Thrift::ApplicationException.new(Thrift::ApplicationException::MISSING_RESULT, 'read failed: unknown result')
    end

    def close(out)
      send_close(out)
      return recv_close()
    end

    def send_close(out)
      send_message('close', Close_args, :out => out)
    end

    def recv_close()
      result = receive_message(Close_result)
      return result.success unless result.success.nil?
      raise result.ouch unless result.ouch.nil?
      raise Thrift::ApplicationException.new(Thrift::ApplicationException::MISSING_RESULT, 'close failed: unknown result')
    end

    def rm(path, recursive)
      send_rm(path, recursive)
      return recv_rm()
    end

    def send_rm(path, recursive)
      send_message('rm', Rm_args, :path => path, :recursive => recursive)
    end

    def recv_rm()
      result = receive_message(Rm_result)
      return result.success unless result.success.nil?
      raise result.ouch unless result.ouch.nil?
      raise Thrift::ApplicationException.new(Thrift::ApplicationException::MISSING_RESULT, 'rm failed: unknown result')
    end

    def rename(path, dest)
      send_rename(path, dest)
      return recv_rename()
    end

    def send_rename(path, dest)
      send_message('rename', Rename_args, :path => path, :dest => dest)
    end

    def recv_rename()
      result = receive_message(Rename_result)
      return result.success unless result.success.nil?
      raise result.ouch unless result.ouch.nil?
      raise Thrift::ApplicationException.new(Thrift::ApplicationException::MISSING_RESULT, 'rename failed: unknown result')
    end

    def mkdirs(path)
      send_mkdirs(path)
      return recv_mkdirs()
    end

    def send_mkdirs(path)
      send_message('mkdirs', Mkdirs_args, :path => path)
    end

    def recv_mkdirs()
      result = receive_message(Mkdirs_result)
      return result.success unless result.success.nil?
      raise result.ouch unless result.ouch.nil?
      raise Thrift::ApplicationException.new(Thrift::ApplicationException::MISSING_RESULT, 'mkdirs failed: unknown result')
    end

    def exists(path)
      send_exists(path)
      return recv_exists()
    end

    def send_exists(path)
      send_message('exists', Exists_args, :path => path)
    end

    def recv_exists()
      result = receive_message(Exists_result)
      return result.success unless result.success.nil?
      raise result.ouch unless result.ouch.nil?
      raise Thrift::ApplicationException.new(Thrift::ApplicationException::MISSING_RESULT, 'exists failed: unknown result')
    end

    def stat(path)
      send_stat(path)
      return recv_stat()
    end

    def send_stat(path)
      send_message('stat', Stat_args, :path => path)
    end

    def recv_stat()
      result = receive_message(Stat_result)
      return result.success unless result.success.nil?
      raise result.ouch unless result.ouch.nil?
      raise Thrift::ApplicationException.new(Thrift::ApplicationException::MISSING_RESULT, 'stat failed: unknown result')
    end

    def listStatus(path)
      send_listStatus(path)
      return recv_listStatus()
    end

    def send_listStatus(path)
      send_message('listStatus', ListStatus_args, :path => path)
    end

    def recv_listStatus()
      result = receive_message(ListStatus_result)
      return result.success unless result.success.nil?
      raise result.ouch unless result.ouch.nil?
      raise Thrift::ApplicationException.new(Thrift::ApplicationException::MISSING_RESULT, 'listStatus failed: unknown result')
    end

    def chmod(path, mode)
      send_chmod(path, mode)
      recv_chmod()
    end

    def send_chmod(path, mode)
      send_message('chmod', Chmod_args, :path => path, :mode => mode)
    end

    def recv_chmod()
      result = receive_message(Chmod_result)
      raise result.ouch unless result.ouch.nil?
      return
    end

    def chown(path, owner, group)
      send_chown(path, owner, group)
      recv_chown()
    end

    def send_chown(path, owner, group)
      send_message('chown', Chown_args, :path => path, :owner => owner, :group => group)
    end

    def recv_chown()
      result = receive_message(Chown_result)
      raise result.ouch unless result.ouch.nil?
      return
    end

    def setReplication(path, replication)
      send_setReplication(path, replication)
      recv_setReplication()
    end

    def send_setReplication(path, replication)
      send_message('setReplication', SetReplication_args, :path => path, :replication => replication)
    end

    def recv_setReplication()
      result = receive_message(SetReplication_result)
      raise result.ouch unless result.ouch.nil?
      return
    end

    def getFileBlockLocations(path, start, length)
      send_getFileBlockLocations(path, start, length)
      return recv_getFileBlockLocations()
    end

    def send_getFileBlockLocations(path, start, length)
      send_message('getFileBlockLocations', GetFileBlockLocations_args, :path => path, :start => start, :length => length)
    end

    def recv_getFileBlockLocations()
      result = receive_message(GetFileBlockLocations_result)
      return result.success unless result.success.nil?
      raise result.ouch unless result.ouch.nil?
      raise Thrift::ApplicationException.new(Thrift::ApplicationException::MISSING_RESULT, 'getFileBlockLocations failed: unknown result')
    end

  end

  class Processor
    include Thrift::Processor

    def process_setInactivityTimeoutPeriod(seqid, iprot, oprot)
      args = read_args(iprot, SetInactivityTimeoutPeriod_args)
      result = SetInactivityTimeoutPeriod_result.new()
      @handler.setInactivityTimeoutPeriod(args.periodInSeconds)
      write_result(result, oprot, 'setInactivityTimeoutPeriod', seqid)
    end

    def process_shutdown(seqid, iprot, oprot)
      args = read_args(iprot, Shutdown_args)
      result = Shutdown_result.new()
      @handler.shutdown(args.status)
      write_result(result, oprot, 'shutdown', seqid)
    end

    def process_create(seqid, iprot, oprot)
      args = read_args(iprot, Create_args)
      result = Create_result.new()
      begin
        result.success = @handler.create(args.path)
      rescue ThriftIOException => ouch
        result.ouch = ouch
      end
      write_result(result, oprot, 'create', seqid)
    end

    def process_createFile(seqid, iprot, oprot)
      args = read_args(iprot, CreateFile_args)
      result = CreateFile_result.new()
      begin
        result.success = @handler.createFile(args.path, args.mode, args.overwrite, args.bufferSize, args.block_replication, args.blocksize)
      rescue ThriftIOException => ouch
        result.ouch = ouch
      end
      write_result(result, oprot, 'createFile', seqid)
    end

    def process_open(seqid, iprot, oprot)
      args = read_args(iprot, Open_args)
      result = Open_result.new()
      begin
        result.success = @handler.open(args.path)
      rescue ThriftIOException => ouch
        result.ouch = ouch
      end
      write_result(result, oprot, 'open', seqid)
    end

    def process_append(seqid, iprot, oprot)
      args = read_args(iprot, Append_args)
      result = Append_result.new()
      begin
        result.success = @handler.append(args.path)
      rescue ThriftIOException => ouch
        result.ouch = ouch
      end
      write_result(result, oprot, 'append', seqid)
    end

    def process_write(seqid, iprot, oprot)
      args = read_args(iprot, Write_args)
      result = Write_result.new()
      begin
        result.success = @handler.write(args.handle, args.data)
      rescue ThriftIOException => ouch
        result.ouch = ouch
      end
      write_result(result, oprot, 'write', seqid)
    end

    def process_read(seqid, iprot, oprot)
      args = read_args(iprot, Read_args)
      result = Read_result.new()
      begin
        result.success = @handler.read(args.handle, args.offset, args.size)
      rescue ThriftIOException => ouch
        result.ouch = ouch
      end
      write_result(result, oprot, 'read', seqid)
    end

    def process_close(seqid, iprot, oprot)
      args = read_args(iprot, Close_args)
      result = Close_result.new()
      begin
        result.success = @handler.close(args.out)
      rescue ThriftIOException => ouch
        result.ouch = ouch
      end
      write_result(result, oprot, 'close', seqid)
    end

    def process_rm(seqid, iprot, oprot)
      args = read_args(iprot, Rm_args)
      result = Rm_result.new()
      begin
        result.success = @handler.rm(args.path, args.recursive)
      rescue ThriftIOException => ouch
        result.ouch = ouch
      end
      write_result(result, oprot, 'rm', seqid)
    end

    def process_rename(seqid, iprot, oprot)
      args = read_args(iprot, Rename_args)
      result = Rename_result.new()
      begin
        result.success = @handler.rename(args.path, args.dest)
      rescue ThriftIOException => ouch
        result.ouch = ouch
      end
      write_result(result, oprot, 'rename', seqid)
    end

    def process_mkdirs(seqid, iprot, oprot)
      args = read_args(iprot, Mkdirs_args)
      result = Mkdirs_result.new()
      begin
        result.success = @handler.mkdirs(args.path)
      rescue ThriftIOException => ouch
        result.ouch = ouch
      end
      write_result(result, oprot, 'mkdirs', seqid)
    end

    def process_exists(seqid, iprot, oprot)
      args = read_args(iprot, Exists_args)
      result = Exists_result.new()
      begin
        result.success = @handler.exists(args.path)
      rescue ThriftIOException => ouch
        result.ouch = ouch
      end
      write_result(result, oprot, 'exists', seqid)
    end

    def process_stat(seqid, iprot, oprot)
      args = read_args(iprot, Stat_args)
      result = Stat_result.new()
      begin
        result.success = @handler.stat(args.path)
      rescue ThriftIOException => ouch
        result.ouch = ouch
      end
      write_result(result, oprot, 'stat', seqid)
    end

    def process_listStatus(seqid, iprot, oprot)
      args = read_args(iprot, ListStatus_args)
      result = ListStatus_result.new()
      begin
        result.success = @handler.listStatus(args.path)
      rescue ThriftIOException => ouch
        result.ouch = ouch
      end
      write_result(result, oprot, 'listStatus', seqid)
    end

    def process_chmod(seqid, iprot, oprot)
      args = read_args(iprot, Chmod_args)
      result = Chmod_result.new()
      begin
        @handler.chmod(args.path, args.mode)
      rescue ThriftIOException => ouch
        result.ouch = ouch
      end
      write_result(result, oprot, 'chmod', seqid)
    end

    def process_chown(seqid, iprot, oprot)
      args = read_args(iprot, Chown_args)
      result = Chown_result.new()
      begin
        @handler.chown(args.path, args.owner, args.group)
      rescue ThriftIOException => ouch
        result.ouch = ouch
      end
      write_result(result, oprot, 'chown', seqid)
    end

    def process_setReplication(seqid, iprot, oprot)
      args = read_args(iprot, SetReplication_args)
      result = SetReplication_result.new()
      begin
        @handler.setReplication(args.path, args.replication)
      rescue ThriftIOException => ouch
        result.ouch = ouch
      end
      write_result(result, oprot, 'setReplication', seqid)
    end

    def process_getFileBlockLocations(seqid, iprot, oprot)
      args = read_args(iprot, GetFileBlockLocations_args)
      result = GetFileBlockLocations_result.new()
      begin
        result.success = @handler.getFileBlockLocations(args.path, args.start, args.length)
      rescue ThriftIOException => ouch
        result.ouch = ouch
      end
      write_result(result, oprot, 'getFileBlockLocations', seqid)
    end

  end

  # HELPER FUNCTIONS AND STRUCTURES

  class SetInactivityTimeoutPeriod_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :periodInSeconds
    FIELDS = {
      1 => {:type => Thrift::Types::I64, :name => 'periodInSeconds'}
    }
  end

  class SetInactivityTimeoutPeriod_result
    include Thrift::Struct
    FIELDS = {

    }
  end

  class Shutdown_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :status
    FIELDS = {
      1 => {:type => Thrift::Types::I32, :name => 'status'}
    }
  end

  class Shutdown_result
    include Thrift::Struct
    FIELDS = {

    }
  end

  class Create_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :path
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'path', :class => Pathname}
    }
  end

  class Create_result
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :success, :ouch
    FIELDS = {
      0 => {:type => Thrift::Types::STRUCT, :name => 'success', :class => ThriftHandle},
      1 => {:type => Thrift::Types::STRUCT, :name => 'ouch', :class => ThriftIOException}
    }
  end

  class CreateFile_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :path, :mode, :overwrite, :bufferSize, :block_replication, :blocksize
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'path', :class => Pathname},
      2 => {:type => Thrift::Types::I16, :name => 'mode'},
      3 => {:type => Thrift::Types::BOOL, :name => 'overwrite'},
      4 => {:type => Thrift::Types::I32, :name => 'bufferSize'},
      5 => {:type => Thrift::Types::I16, :name => 'block_replication'},
      6 => {:type => Thrift::Types::I64, :name => 'blocksize'}
    }
  end

  class CreateFile_result
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :success, :ouch
    FIELDS = {
      0 => {:type => Thrift::Types::STRUCT, :name => 'success', :class => ThriftHandle},
      1 => {:type => Thrift::Types::STRUCT, :name => 'ouch', :class => ThriftIOException}
    }
  end

  class Open_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :path
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'path', :class => Pathname}
    }
  end

  class Open_result
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :success, :ouch
    FIELDS = {
      0 => {:type => Thrift::Types::STRUCT, :name => 'success', :class => ThriftHandle},
      1 => {:type => Thrift::Types::STRUCT, :name => 'ouch', :class => ThriftIOException}
    }
  end

  class Append_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :path
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'path', :class => Pathname}
    }
  end

  class Append_result
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :success, :ouch
    FIELDS = {
      0 => {:type => Thrift::Types::STRUCT, :name => 'success', :class => ThriftHandle},
      1 => {:type => Thrift::Types::STRUCT, :name => 'ouch', :class => ThriftIOException}
    }
  end

  class Write_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :handle, :data
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'handle', :class => ThriftHandle},
      -1 => {:type => Thrift::Types::STRING, :name => 'data'}
    }
  end

  class Write_result
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :success, :ouch
    FIELDS = {
      0 => {:type => Thrift::Types::BOOL, :name => 'success'},
      1 => {:type => Thrift::Types::STRUCT, :name => 'ouch', :class => ThriftIOException}
    }
  end

  class Read_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :handle, :offset, :size
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'handle', :class => ThriftHandle},
      -1 => {:type => Thrift::Types::I64, :name => 'offset'},
      -2 => {:type => Thrift::Types::I32, :name => 'size'}
    }
  end

  class Read_result
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :success, :ouch
    FIELDS = {
      0 => {:type => Thrift::Types::STRING, :name => 'success'},
      1 => {:type => Thrift::Types::STRUCT, :name => 'ouch', :class => ThriftIOException}
    }
  end

  class Close_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :out
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'out', :class => ThriftHandle}
    }
  end

  class Close_result
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :success, :ouch
    FIELDS = {
      0 => {:type => Thrift::Types::BOOL, :name => 'success'},
      1 => {:type => Thrift::Types::STRUCT, :name => 'ouch', :class => ThriftIOException}
    }
  end

  class Rm_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :path, :recursive
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'path', :class => Pathname},
      2 => {:type => Thrift::Types::BOOL, :name => 'recursive'}
    }
  end

  class Rm_result
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :success, :ouch
    FIELDS = {
      0 => {:type => Thrift::Types::BOOL, :name => 'success'},
      1 => {:type => Thrift::Types::STRUCT, :name => 'ouch', :class => ThriftIOException}
    }
  end

  class Rename_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :path, :dest
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'path', :class => Pathname},
      2 => {:type => Thrift::Types::STRUCT, :name => 'dest', :class => Pathname}
    }
  end

  class Rename_result
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :success, :ouch
    FIELDS = {
      0 => {:type => Thrift::Types::BOOL, :name => 'success'},
      1 => {:type => Thrift::Types::STRUCT, :name => 'ouch', :class => ThriftIOException}
    }
  end

  class Mkdirs_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :path
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'path', :class => Pathname}
    }
  end

  class Mkdirs_result
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :success, :ouch
    FIELDS = {
      0 => {:type => Thrift::Types::BOOL, :name => 'success'},
      1 => {:type => Thrift::Types::STRUCT, :name => 'ouch', :class => ThriftIOException}
    }
  end

  class Exists_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :path
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'path', :class => Pathname}
    }
  end

  class Exists_result
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :success, :ouch
    FIELDS = {
      0 => {:type => Thrift::Types::BOOL, :name => 'success'},
      1 => {:type => Thrift::Types::STRUCT, :name => 'ouch', :class => ThriftIOException}
    }
  end

  class Stat_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :path
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'path', :class => Pathname}
    }
  end

  class Stat_result
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :success, :ouch
    FIELDS = {
      0 => {:type => Thrift::Types::STRUCT, :name => 'success', :class => FileStatus},
      1 => {:type => Thrift::Types::STRUCT, :name => 'ouch', :class => ThriftIOException}
    }
  end

  class ListStatus_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :path
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'path', :class => Pathname}
    }
  end

  class ListStatus_result
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :success, :ouch
    FIELDS = {
      0 => {:type => Thrift::Types::LIST, :name => 'success', :element => {:type => Thrift::Types::STRUCT, :class => FileStatus}},
      1 => {:type => Thrift::Types::STRUCT, :name => 'ouch', :class => ThriftIOException}
    }
  end

  class Chmod_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :path, :mode
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'path', :class => Pathname},
      2 => {:type => Thrift::Types::I16, :name => 'mode'}
    }
  end

  class Chmod_result
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :ouch
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'ouch', :class => ThriftIOException}
    }
  end

  class Chown_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :path, :owner, :group
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'path', :class => Pathname},
      2 => {:type => Thrift::Types::STRING, :name => 'owner'},
      3 => {:type => Thrift::Types::STRING, :name => 'group'}
    }
  end

  class Chown_result
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :ouch
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'ouch', :class => ThriftIOException}
    }
  end

  class SetReplication_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :path, :replication
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'path', :class => Pathname},
      2 => {:type => Thrift::Types::I16, :name => 'replication'}
    }
  end

  class SetReplication_result
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :ouch
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'ouch', :class => ThriftIOException}
    }
  end

  class GetFileBlockLocations_args
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :path, :start, :length
    FIELDS = {
      1 => {:type => Thrift::Types::STRUCT, :name => 'path', :class => Pathname},
      2 => {:type => Thrift::Types::I64, :name => 'start'},
      3 => {:type => Thrift::Types::I64, :name => 'length'}
    }
  end

  class GetFileBlockLocations_result
    include Thrift::Struct
    Thrift::Struct.field_accessor self, :success, :ouch
    FIELDS = {
      0 => {:type => Thrift::Types::LIST, :name => 'success', :element => {:type => Thrift::Types::STRUCT, :class => BlockLocation}},
      1 => {:type => Thrift::Types::STRUCT, :name => 'ouch', :class => ThriftIOException}
    }
  end

end

